import { useNavigate } from 'react-router-dom';
import { Button } from '@/components/ui/button';
import { Cake, Heart, Star, Sparkles, MessageCircle, MapPin, CheckCircle } from 'lucide-react';

const HomePage = () => {
  const navigate = useNavigate();
  const openWhatsApp = () => {
    const phoneNumber = '2349060135082';
    const message = 'Hello CakeCamp, I need help with my order';
    
    // Try mobile app first, fallback to web
    const isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);
    
    if (isMobile) {
      // On mobile, use intent URL to open app directly
      window.location.href = `whatsapp://send?phone=${phoneNumber}&text=${encodeURIComponent(message)}`;
      
      // Fallback to web after a short delay if app doesn't open
      setTimeout(() => {
        window.open(`https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`, '_blank');
      }, 1000);
    } else {
      // On desktop, open WhatsApp Web directly
      window.open(`https://web.whatsapp.com/send?phone=${phoneNumber}&text=${encodeURIComponent(message)}`, '_blank');
    }
  };

  return (
    <div className="min-h-screen bg-white">
      <nav className="glass fixed top-0 left-0 right-0 z-50 px-6 py-4 border-b border-gray-100">
        <div className="max-w-7xl mx-auto flex justify-between items-center">
          <div className="flex items-center space-x-2">
            <Cake className="w-8 h-8 text-purple-600" />
            <h1 className="text-2xl font-bold text-gray-900">CakeCamp.ng</h1>
          </div>
          <div className="flex items-center space-x-2 sm:space-x-4">
            <Button data-testid="whatsapp-btn" variant="ghost" onClick={openWhatsApp} className="text-purple-600 hover:text-purple-700 hover:bg-purple-50 text-xs sm:text-sm">
              <MessageCircle className="w-4 h-4 sm:mr-2" />
              <span className="hidden sm:inline">WhatsApp Us</span>
            </Button>
            <Button data-testid="track-order-nav-btn" variant="ghost" onClick={() => navigate('/track')} className="text-purple-600 hover:text-purple-700 hover:bg-purple-50 text-xs sm:text-sm">
              <span className="hidden sm:inline">Track Order</span>
              <span className="sm:hidden">Track</span>
            </Button>
            <Button data-testid="admin-nav-btn" variant="ghost" onClick={() => navigate('/admin')} className="text-purple-600 hover:text-purple-700 hover:bg-purple-50 text-xs sm:text-sm">Admin</Button>
          </div>
        </div>
      </nav>

      <section className="pt-32 pb-20 px-6 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <div className="inline-flex items-center space-x-2 px-4 py-2 rounded-full bg-purple-50">
                <Sparkles className="w-4 h-4 text-purple-600" />
                <span className="text-sm font-medium text-purple-600">Your Celebration, Our Passion</span>
              </div>
              <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-gray-900 leading-tight">
                <span className="text-purple-600">Describe it. Price it. Have it.</span>
              </h1>
              <p className="text-base sm:text-lg text-gray-700 leading-relaxed">Imagine this: <span className="font-semibold">Your cake fantasy, your budget, your moment.</span> We're here to transform your <span onClick={() => navigate('/order')} className="nike-underline font-bold text-purple-600" style={{fontFamily: 'Playfair Display, serif'}}>cakes</span> order into the most delicious reality.</p>
              <div className="flex flex-col gap-4 pt-4">
                <Button 
                  data-testid="order-now-btn" 
                  onClick={() => navigate('/order')} 
                  className="bg-purple-600 hover:bg-purple-700 text-white px-6 sm:px-8 py-6 text-base sm:text-lg rounded-full shadow-lg shake-animation w-full sm:w-auto"
                >
                  <span className="font-semibold">Place an order here and we bake!</span>
                </Button>
                <Button 
                  data-testid="track-order-hero-btn" 
                  onClick={() => navigate('/track')} 
                  variant="outline" 
                  className="border-2 border-purple-600 text-purple-600 hover:bg-purple-50 px-6 sm:px-8 py-4 text-sm sm:text-base rounded-full w-full sm:w-auto"
                >
                  <span className="hidden sm:inline">Already have got an order baking, track it here</span>
                  <span className="sm:hidden">Track Your Order Here</span>
                </Button>
              </div>
            </div>
            <div className="relative">
              <div className="rounded-3xl overflow-hidden shadow-2xl relative">
                {/* GIF Background - Multiple cake images with animation */}
                <div className="relative w-full" style={{aspectRatio: '4/5'}}>
                  <img 
                    src="https://images.unsplash.com/photo-1578985545062-69928b1d9587?w=800&h=1000&fit=crop&q=80"
                    alt="Elegant layered cake"
                    className="absolute inset-0 w-full h-full object-cover cake-animate"
                    style={{animation: 'cakeClimb 8s ease-in-out infinite'}}
                  />
                  <img 
                    src="https://images.unsplash.com/photo-1588195538326-c5b1e5b44d0c?w=800&h=1000&fit=crop&q=80"
                    alt="Beautiful birthday cake"
                    className="absolute inset-0 w-full h-full object-cover cake-animate"
                    style={{animation: 'cakeClimb 8s ease-in-out 2s infinite', opacity: 0}}
                  />
                  <img 
                    src="https://images.unsplash.com/photo-1565958011703-44f9829ba187?w=800&h=1000&fit=crop&q=80"
                    alt="Decorated celebration cake"
                    className="absolute inset-0 w-full h-full object-cover cake-animate"
                    style={{animation: 'cakeClimb 8s ease-in-out 4s infinite', opacity: 0}}
                  />
                  <img 
                    src="https://images.unsplash.com/photo-1562440499-64c9a3f4efae?w=800&h=1000&fit=crop&q=80"
                    alt="Stacked cake layers"
                    className="absolute inset-0 w-full h-full object-cover cake-animate"
                    style={{animation: 'cakeClimb 8s ease-in-out 6s infinite', opacity: 0}}
                  />
                </div>
                
                {/* Logo Overlay with Purple Tint */}
                <div className="absolute inset-0 flex items-center justify-center" style={{background: 'linear-gradient(135deg, rgba(0,0,0,0.3) 0%, rgba(124, 58, 237, 0.4) 100%)'}}>
                  <div className="text-center">
                    <img 
                      src="https://customer-assets.emergentagent.com/job_custom-cake-design/artifacts/91a6j6pc_Cake-Camp-Logo-PNG.png"
                      alt="CakeCamp Logo"
                      className="mx-auto mb-4 w-48 sm:w-64 logo-purple-blend"
                      style={{filter: 'drop-shadow(0 4px 12px rgba(124, 58, 237, 0.6)) brightness(1.1) contrast(1.1) hue-rotate(-10deg) saturate(1.2)'}}
                    />
                    <p className="text-xl sm:text-2xl font-bold text-white" style={{textShadow: '0 2px 8px rgba(124, 58, 237, 0.8)', fontFamily: 'Playfair Display, serif'}}>
                      Where cravings meet budget
                    </p>
                  </div>
                </div>
              </div>
              
              <div className="absolute -top-4 -right-4 bg-white rounded-2xl p-4 shadow-xl z-10 border border-gray-100">
                <div className="flex items-center space-x-2"><Star className="w-5 h-5 text-purple-600 fill-purple-600" /><span className="font-semibold text-gray-900">Crafted For You</span></div>
              </div>
              <div className="absolute -bottom-4 -left-4 bg-white rounded-2xl p-4 shadow-xl z-10 border border-gray-100">
                <div className="flex items-center space-x-2"><Heart className="w-5 h-5 text-purple-600 fill-purple-600" /><span className="font-semibold text-gray-900">Baked with Love</span></div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="py-20 px-6 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-3xl sm:text-4xl font-bold text-gray-900 mb-4">Here's How We Bring Your Cake to Life</h2>
            <p className="text-gray-600 max-w-2xl mx-auto">Three beautiful steps between you and the cake that'll make your celebration unforgettable</p>
          </div>
          <div className="grid md:grid-cols-3 gap-8">
            <div className="bg-white border border-gray-100 rounded-3xl p-8 hover:shadow-xl" style={{transition: 'box-shadow 0.3s ease'}}>
              <div className="w-16 h-16 bg-purple-100 rounded-2xl flex items-center justify-center mb-6"><span className="text-3xl font-bold text-purple-600">1</span></div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">Tell Us Your Budget</h3>
              <p className="text-gray-600">No matter how much you have, we'll work with your budget to create something truly special.</p>
            </div>
            <div className="bg-white border border-gray-100 rounded-3xl p-8 hover:shadow-xl" style={{transition: 'box-shadow 0.3s ease'}}>
              <div className="w-16 h-16 bg-purple-100 rounded-2xl flex items-center justify-center mb-6"><span className="text-3xl font-bold text-purple-600">2</span></div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">Share Your Cake Fantasy</h3>
              <p className="text-gray-600">Show us a picture, tell us your story, or even send us a voice note.</p>
            </div>
            <div className="bg-white border border-gray-100 rounded-3xl p-8 hover:shadow-xl" style={{transition: 'box-shadow 0.3s ease'}}>
              <div className="w-16 h-16 bg-purple-100 rounded-2xl flex items-center justify-center mb-6"><span className="text-3xl font-bold text-purple-600">3</span></div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">We Create Your Masterpiece</h3>
              <p className="text-gray-600">Our talented bakers pour their hearts into every detail.</p>
            </div>
          </div>
        </div>
      </section>

      <section className="py-20 px-6 bg-white">
        <div className="max-w-4xl mx-auto">
          <div className="bg-gradient-to-br from-purple-600 to-purple-700 rounded-3xl p-12 text-center shadow-2xl">
            <h2 className="text-3xl sm:text-4xl font-bold text-white mb-4">Ready to Create Something Beautiful Together?</h2>
            <p className="text-purple-100 mb-8 max-w-2xl mx-auto">Let's make your celebration extraordinary. Your dream cake is just one click away.</p>
            <div className="flex flex-col gap-4 justify-center">
              <Button 
                data-testid="get-started-btn" 
                onClick={() => navigate('/order')} 
                className="bg-white text-purple-600 hover:bg-gray-50 px-8 sm:px-10 py-6 text-base sm:text-lg rounded-full shadow-lg w-full sm:w-auto"
              >
                <span className="hidden sm:inline">Yes, Let's Create Magic!</span>
                <span className="sm:hidden">Create Magic!</span>
              </Button>
              <Button 
                data-testid="whatsapp-cta-btn" 
                onClick={openWhatsApp} 
                variant="outline" 
                className="border-2 border-white text-white hover:bg-white hover:text-purple-600 px-8 sm:px-10 py-6 text-base sm:text-lg rounded-full w-full sm:w-auto"
              >
                <MessageCircle className="w-5 h-5 mr-2" />
                <span className="hidden sm:inline">Chat on WhatsApp</span>
                <span className="sm:hidden">WhatsApp</span>
              </Button>
            </div>
          </div>
        </div>
      </section>

      <footer className="py-8 px-6 border-t border-gray-100 bg-white">
        <div className="max-w-7xl mx-auto">
          {/* Location Hubs */}
          <div className="flex flex-col md:flex-row items-center justify-center space-y-4 md:space-y-0 md:space-x-8 mb-6 pb-6 border-b border-gray-200">
            <div className="flex items-center space-x-2 text-purple-600">
              <MapPin className="w-5 h-5" />
              <span className="font-semibold">Our Baking Hubs in Abuja:</span>
            </div>
            <div className="flex flex-wrap justify-center gap-4 text-gray-700">
              <span className="px-4 py-2 bg-purple-50 rounded-full text-sm font-medium">Wuse</span>
              <span className="px-4 py-2 bg-purple-50 rounded-full text-sm font-medium">Maitama</span>
              <span className="px-4 py-2 bg-purple-50 rounded-full text-sm font-medium">Gwarinpa</span>
              <span className="px-4 py-2 bg-purple-50 rounded-full text-sm font-medium">Asokoro</span>
            </div>
          </div>
          
          {/* Copyright */}
          <div className="text-center text-gray-600">
            <p>&copy; 2025 CakeCamp.ng. Baking dreams into reality, one cake at a time. Made with ♥ in Abuja.</p>
          </div>
        </div>
      </footer>
    </div>
  );
};

export default HomePage;
